/*
 * Name:		James Sheets
 * Class:		CIS 285
 * Assignment:	4
 * Due Date:	4/3/07
 * Language:	Java 1.5
 * Description:	Sample program which calculates calculates calories based on
 * 				fat content.  Percentage = ((Grams of Fat * 9) / calories * 100)
 * 				This simple program is actually being used as a testbed for 
 * 				JUnit testing
 */

import java.io.*;



/*
 *  Main class file
 */
public class Calories
{
	// a gram of fat has 9 calories
    public static final double CALORIES_PER_GRAM = 9.0;

    
    /*
     *  Program entry point
     */
    public static void main (String[] args)
    {
        BufferedReader keyboard;    // input stream
        int    gramsOfFat = 0,      // number of grams of fat in one serving
               totalCalories = 0;   // number of calories in one serving
        double percent;             // percentage of total calories from fat

        System.out.print("This program will tell you what percentage "
        	+ "of the calories in a serving\n"
        	+ "of a food are from the food's fat content.\n\n");

        // Get input from keyboard
        keyboard = new BufferedReader(new InputStreamReader(System.in));

        System.out.print("How many grams of fat are in one serving?  ");
        try {
            gramsOfFat = Integer.parseInt(keyboard.readLine());
        } catch (IOException e) {}

        System.out.print("How many total calories are in one serving?  ");
        try {
            totalCalories = Integer.parseInt(keyboard.readLine());
        } catch (IOException e) {}

        // Compute the percentage of calories due to fat
        try {
        	percent = fatPercentage(gramsOfFat,totalCalories);
        	
//        	 Print results to screen
            if (gramsOfFat == 1) {
                System.out.print("\nA food with 1 gram of fat ");
            } else {
                System.out.print("\nA food with " + gramsOfFat + " grams of fat ");
            }

            if (totalCalories == 1) {
                System.out.print("and 1 calorie per serving\n");
            } else {
                System.out.print("and " + totalCalories + " calories per serving\n");
            }

            System.out.print("has " + twoPlaces(percent) + "% of those calories from fat.\n");
        } catch (Exception e) {
        	System.err.println(e.getMessage());
        }

    }
    

    
    
    /*
     * Name:	fatPercentage
     * Desc:	calculates and returns a fat percentage
     * Params:	gramsOfFat - total grams of fat in the serving
     * 			totalCaloes - total calores in the serving
     * Return:	calculated fat percentage
     */
    public static double fatPercentage(int gramsOfFat, int totalCalories)
    throws Exception
    {
    	if (gramsOfFat < 0)
    		throw new IllegalArgumentException("Grams cannot be less than zero");
    	if (totalCalories < 0)
    		throw new IllegalArgumentException("Calories cannot be less than zero");
    	if ((gramsOfFat * CALORIES_PER_GRAM) > totalCalories)
    		throw new IllegalArgumentException(
    			"There are more grams of fat that possible; The result will be over 100.0%");
    	double fatFraction = (gramsOfFat * CALORIES_PER_GRAM) / totalCalories;
    	double percent = fatFraction * 100;
    		
    	return percent;
    }


    /*
     *  Name:	twoPlaces
     *  Desc:	round a number to two decimal places for output display
     *  Params:	number - the floating point value to be modified
     *  Return:	number rounded to two decimal places
     */
    public static double twoPlaces (double number)
    {
        double shiftRight, // number with . moved two places to the right
               rounded,    // shiftRight w/o extraneous digits
               shiftLeft;  // rounded with decimal point restored

        shiftRight = number * 100;
        rounded = Math.round(shiftRight);
        shiftLeft = rounded / 100;

        return shiftLeft;
     }
}
